"""Lattice definition for the present‑act engine (stub).

In a full implementation, this module would define the 2D lattice
geometry, including slit positions, screen positions, masks, and
allowed movement rules.  The simplified simulation computes fringe
statistics analytically and does not construct an explicit lattice.
The functions below are placeholders to illustrate where such logic
would reside.
"""

from dataclasses import dataclass


@dataclass
class Lattice:
    Lx: int
    Ly: int
    y_slit: int
    slit_halfwidth: int
    slit_offset: int
    y_meter: int
    screen_y: int

    def __post_init__(self) -> None:
        # In a full implementation we would build masks here.
        pass

    def is_within_upper_slit(self, x: int, y: int) -> bool:
        """Placeholder test for being inside the upper slit."""
        return True

    def is_within_lower_slit(self, x: int, y: int) -> bool:
        """Placeholder test for being inside the lower slit."""
        return True